/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;

public class FallbackModelLoader
implements IGeometryLoader<BlockModelWrapper> {
    public static final FallbackModelLoader INSTANCE = new FallbackModelLoader();

    public BlockModelWrapper read(JsonObject data, JsonDeserializationContext context) {
        JsonArray models = class_3518.method_15261((JsonObject)data, (String)"models");
        if (models.size() < 2) {
            throw new JsonSyntaxException("Fallback model must contain at least 2 models");
        }
        for (int i = 0; i < models.size(); ++i) {
            String debugName = "models[" + i + "]";
            JsonObject entry = class_3518.method_15295((JsonElement)models.get(i), (String)debugName);
            String modId = null;
            if (entry.has("fallback_mod_id")) {
                modId = class_3518.method_15265((JsonObject)entry, (String)"fallback_mod_id");
            } else if (entry.has("loader")) {
                class_2960 loader = new class_2960(class_3518.method_15265((JsonObject)entry, (String)"loader"));
                modId = loader.method_12836();
            }
            if (modId != null && !FabricLoader.getInstance().isModLoaded(modId)) continue;
            try {
                return new BlockModelWrapper((class_793)context.deserialize((JsonElement)entry, class_793.class));
            }
            catch (JsonSyntaxException e) {
                throw new JsonSyntaxException("Failed to parse fallback model " + debugName, (Throwable)e);
            }
        }
        throw new JsonSyntaxException("Failed to load fallback model, all " + models.size() + " variants had a failed condition");
    }

    record BlockModelWrapper(class_793 model) implements IUnbakedGeometry<BlockModelWrapper>
    {
        public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
            return this.model.method_3446(baker, this.model, spriteGetter, modelTransform, modelLocation, true);
        }

        public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 owner) {
            this.model.method_45785(modelGetter);
        }
    }
}

